/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.hardware.Camera;
import com.twilio.video.CameraCapturer;
import com.twilio.video.Logger;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoPixelFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webrtc.Camera1Enumerator;

class CameraCapturerFormatProvider {
    private static final Logger logger = Logger.getLogger(CameraCapturerFormatProvider.class);
    private final Map<CameraCapturer.CameraSource, List<VideoFormat>> supportedFormatsMap = new HashMap<CameraCapturer.CameraSource, List<VideoFormat>>();
    private final Camera1Enumerator camera1Enumerator = new Camera1Enumerator(false);

    CameraCapturerFormatProvider() {
    }

    int getCameraId(CameraCapturer.CameraSource cameraSource) {
        int cameraId = -1;
        String[] deviceNames = this.camera1Enumerator.getDeviceNames();
        for (int i = 0; i < deviceNames.length; ++i) {
            if ((!this.camera1Enumerator.isFrontFacing(deviceNames[i]) || cameraSource != CameraCapturer.CameraSource.FRONT_CAMERA) && (!this.camera1Enumerator.isBackFacing(deviceNames[i]) || cameraSource != CameraCapturer.CameraSource.BACK_CAMERA)) continue;
            cameraId = i;
            break;
        }
        return cameraId;
    }

    String getDeviceName(int cameraId) {
        String[] deviceNames = this.camera1Enumerator.getDeviceNames();
        if (cameraId < 0 || cameraId >= deviceNames.length) {
            throw new IllegalArgumentException("cameraId not available on this device");
        }
        return deviceNames[cameraId];
    }

    List<VideoFormat> getSupportedFormats(CameraCapturer.CameraSource cameraSource) {
        List<VideoFormat> supportedFormats = this.supportedFormatsMap.get((Object)cameraSource);
        if (supportedFormats == null) {
            supportedFormats = this.getSupportedFormats(this.getCameraId(cameraSource));
            this.supportedFormatsMap.put(cameraSource, supportedFormats);
        }
        return supportedFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VideoFormat> getSupportedFormats(int cameraId) {
        Camera.Parameters parameters;
        ArrayList<VideoFormat> formatList = new ArrayList<VideoFormat>();
        Camera camera = null;
        try {
            camera = Camera.open((int)cameraId);
            parameters = camera.getParameters();
        }
        catch (RuntimeException e) {
            logger.e(e.getMessage());
            ArrayList<VideoFormat> arrayList = formatList;
            return arrayList;
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        int maxFps = 0;
        List listFpsRange = parameters.getSupportedPreviewFpsRange();
        if (listFpsRange != null) {
            int[] range = (int[])listFpsRange.get(listFpsRange.size() - 1);
            maxFps = (range[1] + 999) / 1000;
        }
        for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
            VideoDimensions dimensions = new VideoDimensions(size.width, size.height);
            formatList.add(new VideoFormat(dimensions, maxFps, VideoPixelFormat.NV21));
        }
        return formatList;
    }
}

