/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.video.AudioOptions;
import com.twilio.video.EglBaseProvider;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoConstraints;
import java.util.HashSet;
import java.util.Set;
import org.webrtc.EglBase;

class MediaFactory {
    private static final String RELEASE_MESSAGE_TEMPLATE = "MediaFactory released %s unavailable";
    private static volatile boolean libraryIsLoaded = false;
    private static final Logger logger = Logger.getLogger(MediaFactory.class);
    private static volatile MediaFactory instance;
    private static volatile Set<Object> mediaFactoryOwners;
    private long nativeMediaFactoryHandle;
    private EglBaseProvider eglBaseProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MediaFactory instance(@NonNull Object owner, @NonNull Context context) {
        Preconditions.checkNotNull(owner, "Owner must not be null");
        Preconditions.checkNotNull(context, "Context must not be null");
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            if (instance == null) {
                if (!libraryIsLoaded) {
                    ReLinker.loadLibrary((Context)context, (String)"jingle_peerconnection_so");
                    libraryIsLoaded = true;
                }
                Object temporaryEglOwner = new Object();
                EglBaseProvider eglBaseProvider = EglBaseProvider.instance(temporaryEglOwner);
                EglBase localEglBase = eglBaseProvider.getLocalEglBase();
                EglBase remoteEglBase = eglBaseProvider.getRemoteEglBase();
                long nativeMediaFactoryHandle = MediaFactory.nativeCreate(context, localEglBase.getEglBaseContext(), remoteEglBase.getEglBaseContext());
                if (nativeMediaFactoryHandle == 0L) {
                    logger.e("Failed to instance MediaFactory");
                } else {
                    instance = new MediaFactory(nativeMediaFactoryHandle);
                }
                eglBaseProvider.release(temporaryEglOwner);
            }
            mediaFactoryOwners.add(owner);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    static boolean isReleased() {
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance == null;
        }
    }

    @Nullable
    synchronized LocalAudioTrack createAudioTrack(Context context, boolean enabled, @Nullable AudioOptions audioOptions) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkState(this.nativeMediaFactoryHandle != 0L, RELEASE_MESSAGE_TEMPLATE, (Object)"createAudioTrack");
        return this.nativeCreateAudioTrack(this.nativeMediaFactoryHandle, context, enabled, audioOptions);
    }

    @Nullable
    synchronized LocalVideoTrack createVideoTrack(Context context, boolean enabled, VideoCapturer videoCapturer, VideoConstraints videoConstraints) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkState(this.nativeMediaFactoryHandle != 0L, RELEASE_MESSAGE_TEMPLATE, (Object)"createVideoTrack");
        return this.nativeCreateVideoTrack(this.nativeMediaFactoryHandle, context, enabled, videoCapturer, videoConstraints, this.eglBaseProvider.getLocalEglBase().getEglBaseContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void release(Object owner) {
        if (instance == null) return;
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            mediaFactoryOwners.remove(owner);
            if (instance == null || !mediaFactoryOwners.isEmpty()) return;
            this.eglBaseProvider.release(this);
            this.eglBaseProvider = null;
            this.nativeRelease(this.nativeMediaFactoryHandle);
            this.nativeMediaFactoryHandle = 0L;
            instance = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    long getNativeMediaFactoryHandle() {
        return this.nativeMediaFactoryHandle;
    }

    private MediaFactory(long nativeMediaFactoryHandle) {
        this.nativeMediaFactoryHandle = nativeMediaFactoryHandle;
        this.eglBaseProvider = EglBaseProvider.instance(this);
    }

    private static native long nativeCreate(Context var0, EglBase.Context var1, EglBase.Context var2);

    private native LocalAudioTrack nativeCreateAudioTrack(long var1, Context var3, boolean var4, AudioOptions var5);

    private native LocalVideoTrack nativeCreateVideoTrack(long var1, Context var3, boolean var4, VideoCapturer var5, VideoConstraints var6, EglBase.Context var7);

    private native void nativeRelease(long var1);

    static {
        mediaFactoryOwners = new HashSet<Object>();
    }
}

