/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.util;

import android.util.Log;
import com.twilio.util.LogWriter;
import com.twilio.util.LogWriterImpl;
import com.twilio.util.LoggingLevel;
import java.io.File;
import java.util.Arrays;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J&\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J&\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J*\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002J&\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J&\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/twilio/util/LogWriterImpl;", "Lcom/twilio/util/LogWriter;", "()V", "dir", "Ljava/io/File;", "getDir", "()Ljava/io/File;", "dir$delegate", "Lkotlin/Lazy;", "fh", "Ljava/util/logging/FileHandler;", "getFh", "()Ljava/util/logging/FileHandler;", "fh$delegate", "kCurrentLogFileName", "", "d", "", "tag", "msg", "t", "", "e", "i", "printLogInFile", "loggingLevel", "Lcom/twilio/util/LoggingLevel;", "rotateLogFile", "v", "w", "shared-internal_release"})
public final class LogWriterImpl
implements LogWriter {
    @NotNull
    public static final LogWriterImpl INSTANCE = new LogWriterImpl();
    @NotNull
    private static final String kCurrentLogFileName = "current.log";
    @NotNull
    private static final Lazy dir$delegate = LazyKt.lazy((Function0)dir.2.INSTANCE);
    @NotNull
    private static final Lazy fh$delegate = LazyKt.lazy((Function0)fh.2.INSTANCE);

    private LogWriterImpl() {
    }

    private final File getDir() {
        Lazy lazy = dir$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-dir>(...)");
        return (File)object;
    }

    private final FileHandler getFh() {
        Lazy lazy = fh$delegate;
        return (FileHandler)lazy.getValue();
    }

    @Override
    public void v(@NotNull String tag, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Log.v((String)tag, (String)msg, (Throwable)t);
        this.printLogInFile(LoggingLevel.VERBOSE.INSTANCE, tag, msg, t);
    }

    @Override
    public void d(@NotNull String tag, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Log.d((String)tag, (String)msg, (Throwable)t);
        this.printLogInFile(LoggingLevel.DEBUG.INSTANCE, tag, msg, t);
    }

    @Override
    public void i(@NotNull String tag, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Log.i((String)tag, (String)msg, (Throwable)t);
        this.printLogInFile(LoggingLevel.INFO.INSTANCE, tag, msg, t);
    }

    @Override
    public void w(@NotNull String tag, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Log.w((String)tag, (String)msg, (Throwable)t);
        this.printLogInFile(LoggingLevel.WARN.INSTANCE, tag, msg, t);
    }

    @Override
    public void e(@NotNull String tag, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Log.e((String)tag, (String)msg, (Throwable)t);
        this.printLogInFile(LoggingLevel.ERROR.INSTANCE, tag, msg, t);
    }

    private final void rotateLogFile() {
        File lastLogFile;
        String backupFileName = "log.bak";
        File lastBackupFile = new File(this.getDir(), backupFileName);
        if (lastBackupFile.exists()) {
            lastBackupFile.delete();
        }
        if ((lastLogFile = new File(this.getDir(), kCurrentLogFileName)).exists()) {
            File newBackupFile = new File(this.getDir(), backupFileName);
            lastLogFile.renameTo(newBackupFile);
        }
    }

    private final void printLogInFile(LoggingLevel loggingLevel, String tag, String msg, Throwable t) {
        Level level = loggingLevel;
        String string = "%s: %s";
        Object[] objectArray = new Object[]{tag, msg};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        LogRecord logRecord = new LogRecord(level, string2);
        logRecord.setThrown(t);
        this.getFh().publish(logRecord);
    }

    public static final /* synthetic */ void access$rotateLogFile(LogWriterImpl $this) {
        $this.rotateLogFile();
    }

    public static final /* synthetic */ File access$getDir(LogWriterImpl $this) {
        return $this.getDir();
    }
}

