/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml;

import com.twilio.twiml.Body;
import com.twilio.twiml.Media;
import com.twilio.twiml.Method;
import com.twilio.twiml.TwiML;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Message")
public class Message
extends TwiML {
    @XmlAttribute
    private final String to;
    @XmlAttribute
    private final String from;
    @XmlAttribute
    private final Method method;
    @XmlAttribute
    private final String action;
    @XmlAttribute
    private final String statusCallback;
    @XmlElement(name="Body")
    private final Body body;
    @XmlElement(name="Media")
    private final Media media;

    private Message() {
        this(new Builder());
    }

    private Message(Builder b) {
        this.to = b.to;
        this.from = b.from;
        this.method = b.method;
        this.action = b.action;
        this.statusCallback = b.statusCallback;
        this.body = b.body;
        this.media = b.media;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getAction() {
        return this.action;
    }

    public String getStatusCallback() {
        return this.statusCallback;
    }

    public Body getBody() {
        return this.body;
    }

    public Media getMedia() {
        return this.media;
    }

    public static class Builder {
        private String to;
        private String from;
        private Method method;
        private String action;
        private String statusCallback;
        private Body body;
        private Media media;

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder body(Body body) {
            this.body = body;
            return this;
        }

        public Builder media(Media media) {
            this.media = media;
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

