/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.twilio.taskrouter.WorkflowRule;
import com.twilio.taskrouter.WorkflowRuleTarget;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class WorkflowConfiguration {
    @JsonProperty(value="task_routing")
    private final TaskRoutingConfiguration taskRouting;

    public WorkflowConfiguration(List<WorkflowRule> workflowRules, WorkflowRuleTarget defaultTarget) throws Exception {
        this.taskRouting = new TaskRoutingConfiguration(workflowRules, defaultTarget);
    }

    @JsonCreator
    public WorkflowConfiguration(@JsonProperty(value="task_routing") TaskRoutingConfiguration taskRouting) {
        this.taskRouting = taskRouting;
    }

    @JsonIgnore
    public List<WorkflowRule> getWorkflowRules() {
        return this.taskRouting.getWorkflowRules();
    }

    @JsonIgnore
    public WorkflowRuleTarget getDefaultTarget() {
        return this.taskRouting.getDefaultTarget();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskRouting", (Object)this.taskRouting).toString();
    }

    public String toJSON() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)out, (Object)this);
        return out.toString();
    }

    public static WorkflowConfiguration parse(String configurationJson) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (WorkflowConfiguration)mapper.readValue(configurationJson, WorkflowConfiguration.class);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    static class TaskRoutingConfiguration {
        @JsonProperty(value="filters")
        private List<WorkflowRule> workflowRules;
        @JsonProperty(value="default_filter")
        private WorkflowRuleTarget defaultTarget;

        @JsonCreator
        public TaskRoutingConfiguration(@JsonProperty(value="filters") List<WorkflowRule> workflowRules, @JsonProperty(value="default_filter") WorkflowRuleTarget defaultTarget) throws Exception {
            if (workflowRules == null || workflowRules.isEmpty()) {
                throw new Exception("Workflow Rules are required when defining a workflow");
            }
            this.workflowRules = workflowRules;
            this.defaultTarget = defaultTarget;
        }

        public List<WorkflowRule> getWorkflowRules() {
            return this.workflowRules;
        }

        public void setWorkflowRules(List<WorkflowRule> workflowRules) {
            this.workflowRules = workflowRules;
        }

        public WorkflowRuleTarget getDefaultTarget() {
            return this.defaultTarget;
        }

        public void setDefaultTarget(WorkflowRuleTarget defaultTarget) {
            this.defaultTarget = defaultTarget;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("workflowRules", this.workflowRules).add("defaultTarget", (Object)this.defaultTarget).toString();
        }
    }
}

