/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.TaskQueue;
import com.twilio.sdk.updater.Updater;

public class TaskQueueUpdater
extends Updater<TaskQueue> {
    private final String workspaceSid;
    private final String sid;
    private String friendlyName;
    private String targetWorkers;
    private String reservationActivitySid;
    private String assignmentActivitySid;
    private Integer maxReservedWorkers;

    public TaskQueueUpdater(String workspaceSid, String sid) {
        this.workspaceSid = workspaceSid;
        this.sid = sid;
    }

    public TaskQueueUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TaskQueueUpdater setTargetWorkers(String targetWorkers) {
        this.targetWorkers = targetWorkers;
        return this;
    }

    public TaskQueueUpdater setReservationActivitySid(String reservationActivitySid) {
        this.reservationActivitySid = reservationActivitySid;
        return this;
    }

    public TaskQueueUpdater setAssignmentActivitySid(String assignmentActivitySid) {
        this.assignmentActivitySid = assignmentActivitySid;
        return this;
    }

    public TaskQueueUpdater setMaxReservedWorkers(Integer maxReservedWorkers) {
        this.maxReservedWorkers = maxReservedWorkers;
        return this;
    }

    @Override
    public TaskQueue execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/TaskQueues/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueue update failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return TaskQueue.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.targetWorkers != null) {
            request.addPostParam("TargetWorkers", this.targetWorkers);
        }
        if (this.reservationActivitySid != null) {
            request.addPostParam("ReservationActivitySid", this.reservationActivitySid);
        }
        if (this.assignmentActivitySid != null) {
            request.addPostParam("AssignmentActivitySid", this.assignmentActivitySid);
        }
        if (this.maxReservedWorkers != null) {
            request.addPostParam("MaxReservedWorkers", this.maxReservedWorkers.toString());
        }
    }
}

