/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.api.v2010.account;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.Address;
import com.twilio.sdk.updater.Updater;

public class AddressUpdater
extends Updater<Address> {
    private final String accountSid;
    private final String sid;
    private String friendlyName;
    private String customerName;
    private String street;
    private String city;
    private String region;
    private String postalCode;

    public AddressUpdater(String accountSid, String sid) {
        this.accountSid = accountSid;
        this.sid = sid;
    }

    public AddressUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AddressUpdater setCustomerName(String customerName) {
        this.customerName = customerName;
        return this;
    }

    public AddressUpdater setStreet(String street) {
        this.street = street;
        return this;
    }

    public AddressUpdater setCity(String city) {
        this.city = city;
        return this;
    }

    public AddressUpdater setRegion(String region) {
        this.region = region;
        return this;
    }

    public AddressUpdater setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Override
    public Address execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Addresses/" + this.sid + ".json", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Address update failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Address.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.customerName != null) {
            request.addPostParam("CustomerName", this.customerName);
        }
        if (this.street != null) {
            request.addPostParam("Street", this.street);
        }
        if (this.city != null) {
            request.addPostParam("City", this.city);
        }
        if (this.region != null) {
            request.addPostParam("Region", this.region);
        }
        if (this.postalCode != null) {
            request.addPostParam("PostalCode", this.postalCode);
        }
    }
}

