/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.taskrouter.v1.workspace.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.taskrouter.v1.workspace.worker.WorkerStatisticsFetcher;
import com.twilio.sdk.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkerStatistics
extends Resource {
    private static final long serialVersionUID = 174071152398170L;
    private final String accountSid;
    private final JsonNode cumulative;
    private final String workerSid;
    private final String workspaceSid;

    public static WorkerStatisticsFetcher fetch(String workspaceSid, String workerSid) {
        return new WorkerStatisticsFetcher(workspaceSid, workerSid);
    }

    public static WorkerStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (WorkerStatistics)objectMapper.readValue(json, WorkerStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkerStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (WorkerStatistics)objectMapper.readValue(json, WorkerStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkerStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="cumulative") JsonNode cumulative, @JsonProperty(value="worker_sid") String workerSid, @JsonProperty(value="workspace_sid") String workspaceSid) {
        this.accountSid = accountSid;
        this.cumulative = cumulative;
        this.workerSid = workerSid;
        this.workspaceSid = workspaceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final JsonNode getCumulative() {
        return this.cumulative;
    }

    public final String getWorkerSid() {
        return this.workerSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerStatistics other = (WorkerStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.cumulative, other.cumulative) && Objects.equals(this.workerSid, other.workerSid) && Objects.equals(this.workspaceSid, other.workspaceSid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.cumulative, this.workerSid, this.workspaceSid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("cumulative", (Object)this.cumulative).add("workerSid", (Object)this.workerSid).add("workspaceSid", (Object)this.workspaceSid).toString();
    }
}

