/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.taskrouter.v1.workspace.ActivityCreator;
import com.twilio.sdk.deleter.taskrouter.v1.workspace.ActivityDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.taskrouter.v1.workspace.ActivityFetcher;
import com.twilio.sdk.reader.taskrouter.v1.workspace.ActivityReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.taskrouter.v1.workspace.ActivityUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Activity
extends SidResource {
    private static final long serialVersionUID = 22270788626396L;
    private final String accountSid;
    private final Boolean available;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String sid;
    private final String workspaceSid;

    public static ActivityFetcher fetch(String workspaceSid, String sid) {
        return new ActivityFetcher(workspaceSid, sid);
    }

    public static ActivityUpdater update(String workspaceSid, String sid, String friendlyName) {
        return new ActivityUpdater(workspaceSid, sid, friendlyName);
    }

    public static ActivityDeleter delete(String workspaceSid, String sid) {
        return new ActivityDeleter(workspaceSid, sid);
    }

    public static ActivityReader read(String workspaceSid) {
        return new ActivityReader(workspaceSid);
    }

    public static ActivityCreator create(String workspaceSid, String friendlyName, Boolean available) {
        return new ActivityCreator(workspaceSid, friendlyName, available);
    }

    public static Activity fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Activity)objectMapper.readValue(json, Activity.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Activity fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Activity)objectMapper.readValue(json, Activity.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Activity(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="available") Boolean available, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="workspace_sid") String workspaceSid) {
        this.accountSid = accountSid;
        this.available = available;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.workspaceSid = workspaceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Boolean getAvailable() {
        return this.available;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity other = (Activity)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.available, other.available) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.workspaceSid, other.workspaceSid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.available, this.dateCreated, this.dateUpdated, this.friendlyName, this.sid, this.workspaceSid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("available", (Object)this.available).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("sid", (Object)this.sid).add("workspaceSid", (Object)this.workspaceSid).toString();
    }
}

