/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.taskrouter.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.taskrouter.v1.WorkspaceCreator;
import com.twilio.sdk.deleter.taskrouter.v1.WorkspaceDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.taskrouter.v1.WorkspaceFetcher;
import com.twilio.sdk.reader.taskrouter.v1.WorkspaceReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.taskrouter.v1.WorkspaceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Workspace
extends SidResource {
    private static final long serialVersionUID = 241476983828355L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String defaultActivityName;
    private final String defaultActivitySid;
    private final String eventCallbackUrl;
    private final String friendlyName;
    private final String sid;
    private final String timeoutActivityName;
    private final String timeoutActivitySid;

    public static WorkspaceFetcher fetch(String sid) {
        return new WorkspaceFetcher(sid);
    }

    public static WorkspaceUpdater update(String sid) {
        return new WorkspaceUpdater(sid);
    }

    public static WorkspaceReader read() {
        return new WorkspaceReader();
    }

    public static WorkspaceCreator create(String friendlyName) {
        return new WorkspaceCreator(friendlyName);
    }

    public static WorkspaceDeleter delete(String sid) {
        return new WorkspaceDeleter(sid);
    }

    public static Workspace fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Workspace)objectMapper.readValue(json, Workspace.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Workspace fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Workspace)objectMapper.readValue(json, Workspace.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Workspace(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="default_activity_name") String defaultActivityName, @JsonProperty(value="default_activity_sid") String defaultActivitySid, @JsonProperty(value="event_callback_url") String eventCallbackUrl, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="timeout_activity_name") String timeoutActivityName, @JsonProperty(value="timeout_activity_sid") String timeoutActivitySid) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.defaultActivityName = defaultActivityName;
        this.defaultActivitySid = defaultActivitySid;
        this.eventCallbackUrl = eventCallbackUrl;
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.timeoutActivityName = timeoutActivityName;
        this.timeoutActivitySid = timeoutActivitySid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDefaultActivityName() {
        return this.defaultActivityName;
    }

    public final String getDefaultActivitySid() {
        return this.defaultActivitySid;
    }

    public final String getEventCallbackUrl() {
        return this.eventCallbackUrl;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getTimeoutActivityName() {
        return this.timeoutActivityName;
    }

    public final String getTimeoutActivitySid() {
        return this.timeoutActivitySid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workspace other = (Workspace)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.defaultActivityName, other.defaultActivityName) && Objects.equals(this.defaultActivitySid, other.defaultActivitySid) && Objects.equals(this.eventCallbackUrl, other.eventCallbackUrl) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.timeoutActivityName, other.timeoutActivityName) && Objects.equals(this.timeoutActivitySid, other.timeoutActivitySid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.defaultActivityName, this.defaultActivitySid, this.eventCallbackUrl, this.friendlyName, this.sid, this.timeoutActivityName, this.timeoutActivitySid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("defaultActivityName", (Object)this.defaultActivityName).add("defaultActivitySid", (Object)this.defaultActivitySid).add("eventCallbackUrl", (Object)this.eventCallbackUrl).add("friendlyName", (Object)this.friendlyName).add("sid", (Object)this.sid).add("timeoutActivityName", (Object)this.timeoutActivityName).add("timeoutActivitySid", (Object)this.timeoutActivitySid).toString();
    }
}

