/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.ipmessaging.v1.service.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.ipmessaging.v1.service.channel.MessageCreator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.ipmessaging.v1.service.channel.MessageFetcher;
import com.twilio.sdk.reader.ipmessaging.v1.service.channel.MessageReader;
import com.twilio.sdk.resource.SidResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
extends SidResource {
    private static final long serialVersionUID = 19477703234495L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String to;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Boolean wasEdited;
    private final String from;
    private final String body;
    private final URI url;

    public static MessageFetcher fetch(String serviceSid, String channelSid, String sid) {
        return new MessageFetcher(serviceSid, channelSid, sid);
    }

    public static MessageCreator create(String serviceSid, String channelSid, String body) {
        return new MessageCreator(serviceSid, channelSid, body);
    }

    public static MessageReader read(String serviceSid, String channelSid) {
        return new MessageReader(serviceSid, channelSid);
    }

    public static Message fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Message)objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Message fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Message)objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Message(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="to") String to, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="was_edited") Boolean wasEdited, @JsonProperty(value="from") String from, @JsonProperty(value="body") String body, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.to = to;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.wasEdited = wasEdited;
        this.from = from;
        this.body = body;
        this.url = url;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getTo() {
        return this.to;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Boolean getWasEdited() {
        return this.wasEdited;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getBody() {
        return this.body;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.to, other.to) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.wasEdited, other.wasEdited) && Objects.equals(this.from, other.from) && Objects.equals(this.body, other.body) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.to, this.dateCreated, this.dateUpdated, this.wasEdited, this.from, this.body, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("to", (Object)this.to).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("wasEdited", (Object)this.wasEdited).add("from", (Object)this.from).add("body", (Object)this.body).add("url", (Object)this.url).toString();
    }
}

