/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account.sms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.CurrencyDeserializer;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.api.v2010.account.sms.SmsMessageCreator;
import com.twilio.sdk.deleter.api.v2010.account.sms.SmsMessageDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.sms.SmsMessageFetcher;
import com.twilio.sdk.reader.api.v2010.account.sms.SmsMessageReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.type.PhoneNumber;
import com.twilio.sdk.updater.api.v2010.account.sms.SmsMessageUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SmsMessage
extends SidResource {
    private static final long serialVersionUID = 35367205451086L;
    private final String accountSid;
    private final String apiVersion;
    private final String body;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime dateSent;
    private final Direction direction;
    private final PhoneNumber from;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final String sid;
    private final Status status;
    private final String to;
    private final String uri;

    public static SmsMessageCreator create(String accountSid, PhoneNumber to, PhoneNumber from, String body) {
        return new SmsMessageCreator(accountSid, to, from, body);
    }

    public static SmsMessageCreator create(String accountSid, PhoneNumber to, PhoneNumber from, List<URI> mediaUrl) {
        return new SmsMessageCreator(accountSid, to, from, mediaUrl);
    }

    public static SmsMessageDeleter delete(String accountSid, String sid) {
        return new SmsMessageDeleter(accountSid, sid);
    }

    public static SmsMessageFetcher fetch(String accountSid, String sid) {
        return new SmsMessageFetcher(accountSid, sid);
    }

    public static SmsMessageReader read(String accountSid) {
        return new SmsMessageReader(accountSid);
    }

    public static SmsMessageUpdater update(String accountSid, String sid) {
        return new SmsMessageUpdater(accountSid, sid);
    }

    public static SmsMessage fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (SmsMessage)objectMapper.readValue(json, SmsMessage.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SmsMessage fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (SmsMessage)objectMapper.readValue(json, SmsMessage.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SmsMessage(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="body") String body, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="date_sent") String dateSent, @JsonProperty(value="direction") Direction direction, @JsonProperty(value="from") PhoneNumber from, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") Status status, @JsonProperty(value="to") String to, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.body = body;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.dateSent = DateConverter.rfc2822DateTimeFromString(dateSent);
        this.direction = direction;
        this.from = from;
        this.price = price;
        this.priceUnit = priceUnit;
        this.sid = sid;
        this.status = status;
        this.to = to;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getBody() {
        return this.body;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final DateTime getDateSent() {
        return this.dateSent;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final PhoneNumber getFrom() {
        return this.from;
    }

    public final BigDecimal getPrice() {
        return this.price;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getTo() {
        return this.to;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsMessage other = (SmsMessage)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.body, other.body) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.dateSent, other.dateSent) && Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.from, other.from) && Objects.equals(this.price, other.price) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.to, other.to) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.body, this.dateCreated, this.dateUpdated, this.dateSent, this.direction, this.from, this.price, this.priceUnit, this.sid, this.status, this.to, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("apiVersion", (Object)this.apiVersion).add("body", (Object)this.body).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("dateSent", (Object)this.dateSent).add("direction", (Object)this.direction).add("from", (Object)this.from).add("price", (Object)this.price).add("priceUnit", (Object)this.priceUnit).add("sid", (Object)this.sid).add("status", (Object)this.status).add("to", (Object)this.to).add("uri", (Object)this.uri).toString();
    }

    public static enum Direction {
        INBOUND("inbound"),
        OUTBOUND_API("outbound-api"),
        OUTBOUND_CALL("outbound-call"),
        OUTBOUND_REPLY("outbound-reply");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Direction forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Direction.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }

    public static enum Status {
        QUEUED("queued"),
        SENDING("sending"),
        SENT("sent"),
        FAILED("failed"),
        RECEIVED("received");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Status.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

