/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.api.v2010.account.call.FeedbackCreator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.call.FeedbackFetcher;
import com.twilio.sdk.resource.Resource;
import com.twilio.sdk.updater.api.v2010.account.call.FeedbackUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Feedback
extends Resource {
    private static final long serialVersionUID = 234556362553174L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final List<Issues> issues;
    private final Integer qualityScore;
    private final String sid;

    public static FeedbackCreator create(String accountSid, String callSid, Integer qualityScore) {
        return new FeedbackCreator(accountSid, callSid, qualityScore);
    }

    public static FeedbackFetcher fetch(String accountSid, String callSid) {
        return new FeedbackFetcher(accountSid, callSid);
    }

    public static FeedbackUpdater update(String accountSid, String callSid, Integer qualityScore) {
        return new FeedbackUpdater(accountSid, callSid, qualityScore);
    }

    public static Feedback fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Feedback)objectMapper.readValue(json, Feedback.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Feedback fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Feedback)objectMapper.readValue(json, Feedback.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Feedback(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="issues") List<Issues> issues, @JsonProperty(value="quality_score") Integer qualityScore, @JsonProperty(value="sid") String sid) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.issues = issues;
        this.qualityScore = qualityScore;
        this.sid = sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final List<Issues> getIssues() {
        return this.issues;
    }

    public final Integer getQualityScore() {
        return this.qualityScore;
    }

    public final String getSid() {
        return this.sid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feedback other = (Feedback)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.issues, other.issues) && Objects.equals(this.qualityScore, other.qualityScore) && Objects.equals(this.sid, other.sid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.issues, this.qualityScore, this.sid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("issues", this.issues).add("qualityScore", (Object)this.qualityScore).add("sid", (Object)this.sid).toString();
    }

    public static enum Issues {
        AUDIO_LATENCY("audio-latency"),
        DIGITS_NOT_CAPTURED("digits-not-captured"),
        DROPPED_CALL("dropped-call"),
        IMPERFECT_AUDIO("imperfect-audio"),
        INCORRECT_CALLER_ID("incorrect-caller-id"),
        ONE_WAY_AUDIO("one-way-audio"),
        POST_DIAL_DELAY("post-dial-delay"),
        UNSOLICITED_CALL("unsolicited-call");

        private final String value;

        private Issues(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Issues forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Issues.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

