/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.api.v2010.account.QueueCreator;
import com.twilio.sdk.deleter.api.v2010.account.QueueDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.QueueFetcher;
import com.twilio.sdk.reader.api.v2010.account.QueueReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.api.v2010.account.QueueUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Queue
extends SidResource {
    private static final long serialVersionUID = 51300543687284L;
    private final String accountSid;
    private final Integer averageWaitTime;
    private final Integer currentSize;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final Integer maxSize;
    private final String sid;
    private final String uri;

    public static QueueFetcher fetch(String accountSid, String sid) {
        return new QueueFetcher(accountSid, sid);
    }

    public static QueueUpdater update(String accountSid, String sid) {
        return new QueueUpdater(accountSid, sid);
    }

    public static QueueDeleter delete(String accountSid, String sid) {
        return new QueueDeleter(accountSid, sid);
    }

    public static QueueReader read(String accountSid) {
        return new QueueReader(accountSid);
    }

    public static QueueCreator create(String accountSid) {
        return new QueueCreator(accountSid);
    }

    public static Queue fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Queue)objectMapper.readValue(json, Queue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Queue fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Queue)objectMapper.readValue(json, Queue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Queue(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="average_wait_time") Integer averageWaitTime, @JsonProperty(value="current_size") Integer currentSize, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="max_size") Integer maxSize, @JsonProperty(value="sid") String sid, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.averageWaitTime = averageWaitTime;
        this.currentSize = currentSize;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.maxSize = maxSize;
        this.sid = sid;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getAverageWaitTime() {
        return this.averageWaitTime;
    }

    public final Integer getCurrentSize() {
        return this.currentSize;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Integer getMaxSize() {
        return this.maxSize;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Queue other = (Queue)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.averageWaitTime, other.averageWaitTime) && Objects.equals(this.currentSize, other.currentSize) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.maxSize, other.maxSize) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.averageWaitTime, this.currentSize, this.dateCreated, this.dateUpdated, this.friendlyName, this.maxSize, this.sid, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("averageWaitTime", (Object)this.averageWaitTime).add("currentSize", (Object)this.currentSize).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("maxSize", (Object)this.maxSize).add("sid", (Object)this.sid).add("uri", (Object)this.uri).toString();
    }
}

