/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.api.v2010.account.IncomingPhoneNumberCreator;
import com.twilio.sdk.deleter.api.v2010.account.IncomingPhoneNumberDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.IncomingPhoneNumberFetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.reader.api.v2010.account.IncomingPhoneNumberReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.type.PhoneNumber;
import com.twilio.sdk.type.PhoneNumberCapabilities;
import com.twilio.sdk.updater.api.v2010.account.IncomingPhoneNumberUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IncomingPhoneNumber
extends SidResource {
    private static final long serialVersionUID = 40781203062485L;
    private final String accountSid;
    private final AddressRequirement addressRequirements;
    private final String apiVersion;
    private final Boolean beta;
    private final PhoneNumberCapabilities capabilities;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final PhoneNumber phoneNumber;
    private final String sid;
    private final String smsApplicationSid;
    private final HttpMethod smsFallbackMethod;
    private final URI smsFallbackUrl;
    private final HttpMethod smsMethod;
    private final URI smsUrl;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String uri;
    private final String voiceApplicationSid;
    private final Boolean voiceCallerIdLookup;
    private final HttpMethod voiceFallbackMethod;
    private final URI voiceFallbackUrl;
    private final HttpMethod voiceMethod;
    private final URI voiceUrl;

    public static IncomingPhoneNumberUpdater update(String ownerAccountSid, String sid) {
        return new IncomingPhoneNumberUpdater(ownerAccountSid, sid);
    }

    public static IncomingPhoneNumberFetcher fetch(String ownerAccountSid, String sid) {
        return new IncomingPhoneNumberFetcher(ownerAccountSid, sid);
    }

    public static IncomingPhoneNumberDeleter delete(String ownerAccountSid, String sid) {
        return new IncomingPhoneNumberDeleter(ownerAccountSid, sid);
    }

    public static IncomingPhoneNumberReader read(String ownerAccountSid) {
        return new IncomingPhoneNumberReader(ownerAccountSid);
    }

    public static IncomingPhoneNumberCreator create(String ownerAccountSid, PhoneNumber phoneNumber) {
        return new IncomingPhoneNumberCreator(ownerAccountSid, phoneNumber);
    }

    public static IncomingPhoneNumberCreator create(String ownerAccountSid, String areaCode) {
        return new IncomingPhoneNumberCreator(ownerAccountSid, areaCode);
    }

    public static IncomingPhoneNumber fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (IncomingPhoneNumber)objectMapper.readValue(json, IncomingPhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static IncomingPhoneNumber fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (IncomingPhoneNumber)objectMapper.readValue(json, IncomingPhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private IncomingPhoneNumber(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="address_requirements") AddressRequirement addressRequirements, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="beta") Boolean beta, @JsonProperty(value="capabilities") PhoneNumberCapabilities capabilities, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="sid") String sid, @JsonProperty(value="sms_application_sid") String smsApplicationSid, @JsonProperty(value="sms_fallback_method") HttpMethod smsFallbackMethod, @JsonProperty(value="sms_fallback_url") URI smsFallbackUrl, @JsonProperty(value="sms_method") HttpMethod smsMethod, @JsonProperty(value="sms_url") URI smsUrl, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="status_callback_method") HttpMethod statusCallbackMethod, @JsonProperty(value="uri") String uri, @JsonProperty(value="voice_application_sid") String voiceApplicationSid, @JsonProperty(value="voice_caller_id_lookup") Boolean voiceCallerIdLookup, @JsonProperty(value="voice_fallback_method") HttpMethod voiceFallbackMethod, @JsonProperty(value="voice_fallback_url") URI voiceFallbackUrl, @JsonProperty(value="voice_method") HttpMethod voiceMethod, @JsonProperty(value="voice_url") URI voiceUrl) {
        this.accountSid = accountSid;
        this.addressRequirements = addressRequirements;
        this.apiVersion = apiVersion;
        this.beta = beta;
        this.capabilities = capabilities;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.phoneNumber = phoneNumber;
        this.sid = sid;
        this.smsApplicationSid = smsApplicationSid;
        this.smsFallbackMethod = smsFallbackMethod;
        this.smsFallbackUrl = smsFallbackUrl;
        this.smsMethod = smsMethod;
        this.smsUrl = smsUrl;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.uri = uri;
        this.voiceApplicationSid = voiceApplicationSid;
        this.voiceCallerIdLookup = voiceCallerIdLookup;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceMethod = voiceMethod;
        this.voiceUrl = voiceUrl;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final AddressRequirement getAddressRequirements() {
        return this.addressRequirements;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final Boolean getBeta() {
        return this.beta;
    }

    public final PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getSmsApplicationSid() {
        return this.smsApplicationSid;
    }

    public final HttpMethod getSmsFallbackMethod() {
        return this.smsFallbackMethod;
    }

    public final URI getSmsFallbackUrl() {
        return this.smsFallbackUrl;
    }

    public final HttpMethod getSmsMethod() {
        return this.smsMethod;
    }

    public final URI getSmsUrl() {
        return this.smsUrl;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final String getUri() {
        return this.uri;
    }

    public final String getVoiceApplicationSid() {
        return this.voiceApplicationSid;
    }

    public final Boolean getVoiceCallerIdLookup() {
        return this.voiceCallerIdLookup;
    }

    public final HttpMethod getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public final URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomingPhoneNumber other = (IncomingPhoneNumber)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.addressRequirements, (Object)other.addressRequirements) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.beta, other.beta) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.sid, other.sid) && Objects.equals(this.smsApplicationSid, other.smsApplicationSid) && Objects.equals((Object)this.smsFallbackMethod, (Object)other.smsFallbackMethod) && Objects.equals(this.smsFallbackUrl, other.smsFallbackUrl) && Objects.equals((Object)this.smsMethod, (Object)other.smsMethod) && Objects.equals(this.smsUrl, other.smsUrl) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals((Object)this.statusCallbackMethod, (Object)other.statusCallbackMethod) && Objects.equals(this.uri, other.uri) && Objects.equals(this.voiceApplicationSid, other.voiceApplicationSid) && Objects.equals(this.voiceCallerIdLookup, other.voiceCallerIdLookup) && Objects.equals((Object)this.voiceFallbackMethod, (Object)other.voiceFallbackMethod) && Objects.equals(this.voiceFallbackUrl, other.voiceFallbackUrl) && Objects.equals((Object)this.voiceMethod, (Object)other.voiceMethod) && Objects.equals(this.voiceUrl, other.voiceUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.addressRequirements, this.apiVersion, this.beta, this.capabilities, this.dateCreated, this.dateUpdated, this.friendlyName, this.phoneNumber, this.sid, this.smsApplicationSid, this.smsFallbackMethod, this.smsFallbackUrl, this.smsMethod, this.smsUrl, this.statusCallback, this.statusCallbackMethod, this.uri, this.voiceApplicationSid, this.voiceCallerIdLookup, this.voiceFallbackMethod, this.voiceFallbackUrl, this.voiceMethod, this.voiceUrl});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("addressRequirements", (Object)this.addressRequirements).add("apiVersion", (Object)this.apiVersion).add("beta", (Object)this.beta).add("capabilities", (Object)this.capabilities).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("phoneNumber", (Object)this.phoneNumber).add("sid", (Object)this.sid).add("smsApplicationSid", (Object)this.smsApplicationSid).add("smsFallbackMethod", (Object)this.smsFallbackMethod).add("smsFallbackUrl", (Object)this.smsFallbackUrl).add("smsMethod", (Object)this.smsMethod).add("smsUrl", (Object)this.smsUrl).add("statusCallback", (Object)this.statusCallback).add("statusCallbackMethod", (Object)this.statusCallbackMethod).add("uri", (Object)this.uri).add("voiceApplicationSid", (Object)this.voiceApplicationSid).add("voiceCallerIdLookup", (Object)this.voiceCallerIdLookup).add("voiceFallbackMethod", (Object)this.voiceFallbackMethod).add("voiceFallbackUrl", (Object)this.voiceFallbackUrl).add("voiceMethod", (Object)this.voiceMethod).add("voiceUrl", (Object)this.voiceUrl).toString();
    }

    public static enum AddressRequirement {
        NONE("none"),
        ANY("any"),
        LOCAL("local"),
        FOREIGN("foreign");

        private final String value;

        private AddressRequirement(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static AddressRequirement forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return AddressRequirement.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

