/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.Worker;

public class WorkerReader
extends Reader<Worker> {
    private final String workspaceSid;
    private String activityName;
    private String activitySid;
    private String available;
    private String friendlyName;
    private String targetWorkersExpression;
    private String taskQueueName;
    private String taskQueueSid;

    public WorkerReader(String workspaceSid) {
        this.workspaceSid = workspaceSid;
    }

    public WorkerReader byActivityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    public WorkerReader byActivitySid(String activitySid) {
        this.activitySid = activitySid;
        return this;
    }

    public WorkerReader byAvailable(String available) {
        this.available = available;
        return this;
    }

    public WorkerReader byFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WorkerReader byTargetWorkersExpression(String targetWorkersExpression) {
        this.targetWorkersExpression = targetWorkersExpression;
        return this;
    }

    public WorkerReader byTaskQueueName(String taskQueueName) {
        this.taskQueueName = taskQueueName;
        return this;
    }

    public WorkerReader byTaskQueueSid(String taskQueueSid) {
        this.taskQueueSid = taskQueueSid;
        return this;
    }

    @Override
    public ResourceSet<Worker> execute(TwilioRestClient client) {
        return new ResourceSet<Worker>(this, client, this.firstPage());
    }

    @Override
    public Page<Worker> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Workers", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Worker> nextPage(Page<Worker> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Worker> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Worker read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("workers", response.getContent(), Worker.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.activityName != null) {
            request.addQueryParam("ActivityName", this.activityName);
        }
        if (this.activitySid != null) {
            request.addQueryParam("ActivitySid", this.activitySid);
        }
        if (this.available != null) {
            request.addQueryParam("Available", this.available);
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.targetWorkersExpression != null) {
            request.addQueryParam("TargetWorkersExpression", this.targetWorkersExpression);
        }
        if (this.taskQueueName != null) {
            request.addQueryParam("TaskQueueName", this.taskQueueName);
        }
        if (this.taskQueueSid != null) {
            request.addQueryParam("TaskQueueSid", this.taskQueueSid);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

