/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.Event;
import org.joda.time.DateTime;

public class EventReader
extends Reader<Event> {
    private final String workspaceSid;
    private DateTime endDate;
    private String eventType;
    private Integer minutes;
    private String reservationSid;
    private DateTime startDate;
    private String taskQueueSid;
    private String taskSid;
    private String workerSid;
    private String workflowSid;

    public EventReader(String workspaceSid) {
        this.workspaceSid = workspaceSid;
    }

    public EventReader byEndDate(DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public EventReader byEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public EventReader byMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public EventReader byReservationSid(String reservationSid) {
        this.reservationSid = reservationSid;
        return this;
    }

    public EventReader byStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public EventReader byTaskQueueSid(String taskQueueSid) {
        this.taskQueueSid = taskQueueSid;
        return this;
    }

    public EventReader byTaskSid(String taskSid) {
        this.taskSid = taskSid;
        return this;
    }

    public EventReader byWorkerSid(String workerSid) {
        this.workerSid = workerSid;
        return this;
    }

    public EventReader byWorkflowSid(String workflowSid) {
        this.workflowSid = workflowSid;
        return this;
    }

    @Override
    public ResourceSet<Event> execute(TwilioRestClient client) {
        return new ResourceSet<Event>(this, client, this.firstPage());
    }

    @Override
    public Page<Event> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Events", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> nextPage(Page<Event> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Event> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Event read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("events", response.getContent(), Event.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toString());
        }
        if (this.eventType != null) {
            request.addQueryParam("EventType", this.eventType);
        }
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.reservationSid != null) {
            request.addQueryParam("ReservationSid", this.reservationSid);
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toString());
        }
        if (this.taskQueueSid != null) {
            request.addQueryParam("TaskQueueSid", this.taskQueueSid);
        }
        if (this.taskSid != null) {
            request.addQueryParam("TaskSid", this.taskSid);
        }
        if (this.workerSid != null) {
            request.addQueryParam("WorkerSid", this.workerSid);
        }
        if (this.workflowSid != null) {
            request.addQueryParam("WorkflowSid", this.workflowSid);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

