/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.monitor.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.monitor.v1.Event;

public class EventReader
extends Reader<Event> {
    private String actorSid;
    private String endDate;
    private String eventType;
    private String resourceSid;
    private String sourceIpAddress;
    private String startDate;

    public EventReader byActorSid(String actorSid) {
        this.actorSid = actorSid;
        return this;
    }

    public EventReader byEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    public EventReader byEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public EventReader byResourceSid(String resourceSid) {
        this.resourceSid = resourceSid;
        return this;
    }

    public EventReader bySourceIpAddress(String sourceIpAddress) {
        this.sourceIpAddress = sourceIpAddress;
        return this;
    }

    public EventReader byStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @Override
    public ResourceSet<Event> execute(TwilioRestClient client) {
        return new ResourceSet<Event>(this, client, this.firstPage());
    }

    @Override
    public Page<Event> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.MONITOR, "/v1/Events", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> nextPage(Page<Event> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Event> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Event read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("events", response.getContent(), Event.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.actorSid != null) {
            request.addQueryParam("ActorSid", this.actorSid);
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate);
        }
        if (this.eventType != null) {
            request.addQueryParam("EventType", this.eventType);
        }
        if (this.resourceSid != null) {
            request.addQueryParam("ResourceSid", this.resourceSid);
        }
        if (this.sourceIpAddress != null) {
            request.addQueryParam("SourceIpAddress", this.sourceIpAddress);
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

