/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.taskrouter.v1.workspace.workflow;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.workflow.WorkflowStatistics;
import org.joda.time.DateTime;

public class WorkflowStatisticsFetcher
extends Fetcher<WorkflowStatistics> {
    private final String workspaceSid;
    private final String workflowSid;
    private Integer minutes;
    private DateTime startDate;
    private DateTime endDate;

    public WorkflowStatisticsFetcher(String workspaceSid, String workflowSid) {
        this.workspaceSid = workspaceSid;
        this.workflowSid = workflowSid;
    }

    public WorkflowStatisticsFetcher setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public WorkflowStatisticsFetcher setStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public WorkflowStatisticsFetcher setEndDate(DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Override
    public WorkflowStatistics execute(TwilioRestClient client) {
        Response response;
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Workflows/" + this.workflowSid + "/Statistics", client.getAccountSid());
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toString());
        }
        if ((response = client.request(request)) == null) {
            throw new ApiConnectionException("WorkflowStatistics fetch failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return WorkflowStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }
}

