/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.taskrouter.v1.workspace.worker;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.worker.WorkerStatistics;
import org.joda.time.DateTime;

public class WorkerStatisticsFetcher
extends Fetcher<WorkerStatistics> {
    private final String workspaceSid;
    private final String workerSid;
    private Integer minutes;
    private DateTime startDate;
    private DateTime endDate;

    public WorkerStatisticsFetcher(String workspaceSid, String workerSid) {
        this.workspaceSid = workspaceSid;
        this.workerSid = workerSid;
    }

    public WorkerStatisticsFetcher setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public WorkerStatisticsFetcher setStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public WorkerStatisticsFetcher setEndDate(DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Override
    public WorkerStatistics execute(TwilioRestClient client) {
        Response response;
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Workers/" + this.workerSid + "/Statistics", client.getAccountSid());
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toString());
        }
        if ((response = client.request(request)) == null) {
            throw new ApiConnectionException("WorkerStatistics fetch failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return WorkerStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }
}

