/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.deleter.ipmessaging.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.deleter.Deleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.ipmessaging.v1.Credential;

public class CredentialDeleter
extends Deleter<Credential> {
    private final String sid;

    public CredentialDeleter(String sid) {
        this.sid = sid;
    }

    @Override
    public boolean execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.DELETE, TwilioRestClient.Domains.IPMESSAGING, "/v1/Credentials/" + this.sid + "", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Credential delete failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 204) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return true;
    }
}

