/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.trunking.v1.trunk;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.trunking.v1.trunk.PhoneNumber;

public class PhoneNumberCreator
extends Creator<PhoneNumber> {
    private final String trunkSid;
    private final String phoneNumberSid;

    public PhoneNumberCreator(String trunkSid, String phoneNumberSid) {
        this.trunkSid = trunkSid;
        this.phoneNumberSid = phoneNumberSid;
    }

    @Override
    public PhoneNumber execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TRUNKING, "/v1/Trunks/" + this.trunkSid + "/PhoneNumbers", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneNumber creation failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 201) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.phoneNumberSid != null) {
            request.addPostParam("PhoneNumberSid", this.phoneNumberSid);
        }
    }
}

