/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.notifications.v1.service;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.notifications.v1.service.Notification;
import java.util.List;

public class NotificationCreator
extends Creator<Notification> {
    private final String serviceSid;
    private List<String> identity;
    private List<String> tag;
    private String body;
    private String priority;
    private Integer ttl;
    private String title;
    private String sound;
    private String action;
    private String data;
    private String apn;
    private String gcm;

    public NotificationCreator(String serviceSid) {
        this.serviceSid = serviceSid;
    }

    public NotificationCreator setIdentity(List<String> identity) {
        this.identity = identity;
        return this;
    }

    public NotificationCreator setIdentity(String identity) {
        return this.setIdentity(Promoter.listOfOne(identity));
    }

    public NotificationCreator setTag(List<String> tag) {
        this.tag = tag;
        return this;
    }

    public NotificationCreator setTag(String tag) {
        return this.setTag(Promoter.listOfOne(tag));
    }

    public NotificationCreator setBody(String body) {
        this.body = body;
        return this;
    }

    public NotificationCreator setPriority(String priority) {
        this.priority = priority;
        return this;
    }

    public NotificationCreator setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public NotificationCreator setTitle(String title) {
        this.title = title;
        return this;
    }

    public NotificationCreator setSound(String sound) {
        this.sound = sound;
        return this;
    }

    public NotificationCreator setAction(String action) {
        this.action = action;
        return this;
    }

    public NotificationCreator setData(String data) {
        this.data = data;
        return this;
    }

    public NotificationCreator setApn(String apn) {
        this.apn = apn;
        return this;
    }

    public NotificationCreator setGcm(String gcm) {
        this.gcm = gcm;
        return this;
    }

    @Override
    public Notification execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.NOTIFICATIONS, "/v1/Services/" + this.serviceSid + "/Notifications", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Notification creation failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 201) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Notification.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            for (String prop : this.identity) {
                request.addPostParam("Identity", prop.toString());
            }
        }
        if (this.tag != null) {
            for (String prop : this.tag) {
                request.addPostParam("Tag", prop.toString());
            }
        }
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority);
        }
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
        if (this.title != null) {
            request.addPostParam("Title", this.title);
        }
        if (this.sound != null) {
            request.addPostParam("Sound", this.sound);
        }
        if (this.action != null) {
            request.addPostParam("Action", this.action);
        }
        if (this.data != null) {
            request.addPostParam("Data", this.data);
        }
        if (this.apn != null) {
            request.addPostParam("Apn", this.apn);
        }
        if (this.gcm != null) {
            request.addPostParam("Gcm", this.gcm);
        }
    }
}

