/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class CapabilityToken {
    protected static String jwtEncode(Map<String, Object> payload, String key) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("typ", "JWT");
        header.put("alg", "HS256");
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(CapabilityToken.encodeBase64(CapabilityToken.jsonEncode(header)));
        segments.add(CapabilityToken.encodeBase64(CapabilityToken.jsonEncode(payload)));
        String signingInput = Joiner.on((String)".").join(segments);
        String signature = CapabilityToken.sign(signingInput, key);
        segments.add(signature);
        return Joiner.on((String)".").join(segments);
    }

    private static String jsonEncode(Object object) {
        String json = null;
        try {
            json = new ObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            return null;
        }
        return json.replace("\\/", "/");
    }

    private static String encodeBase64(String data) throws UnsupportedEncodingException {
        return CapabilityToken.encodeBase64(data.getBytes("UTF-8"));
    }

    private static String encodeBase64(byte[] data) throws UnsupportedEncodingException {
        String encodedString = new String(Base64.encodeBase64((byte[])data));
        return encodedString.replace('+', '-').replace('/', '_').replace("=", "");
    }

    private static String sign(String data, String key) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
        return CapabilityToken.encodeBase64(rawHmac);
    }

    public static class DomainException
    extends Exception {
        public DomainException(String message) {
            super(message);
        }

        public DomainException(Exception e) {
            super(e);
        }
    }
}

