/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.trunking.v1.trunk;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.trunking.v1.trunk.OriginationUrl;
import com.twilio.sdk.updater.Updater;
import java.net.URI;

public class OriginationUrlUpdater
extends Updater<OriginationUrl> {
    private final String trunkSid;
    private final String sid;
    private Integer weight;
    private Integer priority;
    private Boolean enabled;
    private String friendlyName;
    private URI sipUrl;

    public OriginationUrlUpdater(String trunkSid, String sid) {
        this.trunkSid = trunkSid;
        this.sid = sid;
    }

    public OriginationUrlUpdater setWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public OriginationUrlUpdater setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public OriginationUrlUpdater setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OriginationUrlUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public OriginationUrlUpdater setSipUrl(URI sipUrl) {
        this.sipUrl = sipUrl;
        return this;
    }

    public OriginationUrlUpdater setSipUrl(String sipUrl) {
        return this.setSipUrl(Promoter.uriFromString(sipUrl));
    }

    @Override
    public OriginationUrl execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TRUNKING, "/v1/Trunks/" + this.trunkSid + "/OriginationUrls/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("OriginationUrl update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return OriginationUrl.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.weight != null) {
            request.addPostParam("Weight", this.weight.toString());
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
        if (this.enabled != null) {
            request.addPostParam("Enabled", this.enabled.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.sipUrl != null) {
            request.addPostParam("SipUrl", this.sipUrl.toString());
        }
    }
}

