/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.Worker;
import com.twilio.sdk.updater.Updater;

public class WorkerUpdater
extends Updater<Worker> {
    private final String workspaceSid;
    private final String sid;
    private String activitySid;
    private String attributes;
    private String friendlyName;

    public WorkerUpdater(String workspaceSid, String sid) {
        this.workspaceSid = workspaceSid;
        this.sid = sid;
    }

    public WorkerUpdater setActivitySid(String activitySid) {
        this.activitySid = activitySid;
        return this;
    }

    public WorkerUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public WorkerUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public Worker execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Workers/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Worker update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Worker.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.activitySid != null) {
            request.addPostParam("ActivitySid", this.activitySid);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

