/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.preview.wireless;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.preview.wireless.Device;
import com.twilio.sdk.updater.Updater;
import java.net.URI;

public class DeviceUpdater
extends Updater<Device> {
    private final String sid;
    private String alias;
    private String callbackMethod;
    private URI callbackUrl;
    private String friendlyName;
    private String simIdentifier;
    private String status;
    private String commandsCallbackMethod;
    private URI commandsCallbackUrl;

    public DeviceUpdater(String sid) {
        this.sid = sid;
    }

    public DeviceUpdater setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public DeviceUpdater setCallbackMethod(String callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public DeviceUpdater setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public DeviceUpdater setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public DeviceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public DeviceUpdater setSimIdentifier(String simIdentifier) {
        this.simIdentifier = simIdentifier;
        return this;
    }

    public DeviceUpdater setStatus(String status) {
        this.status = status;
        return this;
    }

    public DeviceUpdater setCommandsCallbackMethod(String commandsCallbackMethod) {
        this.commandsCallbackMethod = commandsCallbackMethod;
        return this;
    }

    public DeviceUpdater setCommandsCallbackUrl(URI commandsCallbackUrl) {
        this.commandsCallbackUrl = commandsCallbackUrl;
        return this;
    }

    public DeviceUpdater setCommandsCallbackUrl(String commandsCallbackUrl) {
        return this.setCommandsCallbackUrl(Promoter.uriFromString(commandsCallbackUrl));
    }

    @Override
    public Device execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.PREVIEW, "/wireless/Devices/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Device update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Device.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.alias != null) {
            request.addPostParam("Alias", this.alias);
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod);
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.simIdentifier != null) {
            request.addPostParam("SimIdentifier", this.simIdentifier);
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status);
        }
        if (this.commandsCallbackMethod != null) {
            request.addPostParam("CommandsCallbackMethod", this.commandsCallbackMethod);
        }
        if (this.commandsCallbackUrl != null) {
            request.addPostParam("CommandsCallbackUrl", this.commandsCallbackUrl.toString());
        }
    }
}

