/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account.sip.credentiallist;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.api.v2010.account.sip.credentiallist.CredentialCreator;
import com.twilio.sdk.deleter.api.v2010.account.sip.credentiallist.CredentialDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.sip.credentiallist.CredentialFetcher;
import com.twilio.sdk.reader.api.v2010.account.sip.credentiallist.CredentialReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.api.v2010.account.sip.credentiallist.CredentialUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Credential
extends SidResource {
    private static final long serialVersionUID = 207131851434233L;
    private final String sid;
    private final String accountSid;
    private final String credentialListSid;
    private final String username;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String uri;

    public static CredentialReader read(String accountSid, String credentialListSid) {
        return new CredentialReader(accountSid, credentialListSid);
    }

    public static CredentialCreator create(String accountSid, String credentialListSid, String username, String password) {
        return new CredentialCreator(accountSid, credentialListSid, username, password);
    }

    public static CredentialFetcher fetch(String accountSid, String credentialListSid, String sid) {
        return new CredentialFetcher(accountSid, credentialListSid, sid);
    }

    public static CredentialUpdater update(String accountSid, String credentialListSid, String sid, String username, String password) {
        return new CredentialUpdater(accountSid, credentialListSid, sid, username, password);
    }

    public static CredentialDeleter delete(String accountSid, String credentialListSid, String sid) {
        return new CredentialDeleter(accountSid, credentialListSid, sid);
    }

    public static Credential fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Credential)objectMapper.readValue(json, Credential.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Credential fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Credential)objectMapper.readValue(json, Credential.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Credential(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="credential_list_sid") String credentialListSid, @JsonProperty(value="username") String username, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="uri") String uri) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.credentialListSid = credentialListSid;
        this.username = username;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.uri = uri;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCredentialListSid() {
        return this.credentialListSid;
    }

    public final String getUsername() {
        return this.username;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credential other = (Credential)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.credentialListSid, other.credentialListSid) && Objects.equals(this.username, other.username) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.credentialListSid, this.username, this.dateCreated, this.dateUpdated, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("credentialListSid", (Object)this.credentialListSid).add("username", (Object)this.username).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("uri", (Object)this.uri).toString();
    }
}

