/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.sdk.exception.ApiConnectionException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class Page<T> {
    private final List<T> records;
    private final String firstPageUri;
    private final String nextPageUri;
    private final String previousPageUri;
    private final String uri;
    private final int pageSize;

    private Page(Builder<T> b) {
        this.records = ((Builder)b).records;
        this.firstPageUri = ((Builder)b).firstPageUri;
        this.nextPageUri = ((Builder)b).nextPageUri;
        this.previousPageUri = ((Builder)b).previousPageUri;
        this.uri = ((Builder)b).uri;
        this.pageSize = ((Builder)b).pageSize;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public String getFirstPageUri() {
        return this.firstPageUri;
    }

    public String getNextPageUri() {
        return this.nextPageUri;
    }

    public String getPreviousPageUri() {
        return this.previousPageUri;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getUri() {
        return this.uri;
    }

    public static <T> Page<T> fromJson(String recordKey, String json, Class<T> recordType, ObjectMapper mapper) {
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            JsonNode root = mapper.readTree(json);
            JsonNode records = root.get(recordKey);
            for (JsonNode record : records) {
                results.add(mapper.readValue(record.toString(), recordType));
            }
            JsonNode uriNode = root.get("uri");
            if (uriNode != null) {
                return Page.buildPage(root, results);
            }
            return Page.buildNextGenPage(root, results);
        }
        catch (IOException e) {
            throw new ApiConnectionException("Unable to deserialize response: " + e.getMessage() + "\nJSON: " + json, e);
        }
    }

    private static <T> Page<T> buildPage(JsonNode root, List<T> results) {
        JsonNode pageSizeNode;
        JsonNode firstPageNode;
        JsonNode previousPageNode;
        Builder<T> builder = new Builder().uri(root.get("uri").asText());
        JsonNode nextPageNode = root.get("next_page_uri");
        if (nextPageNode != null && !nextPageNode.isNull()) {
            builder.nextPageUri(nextPageNode.asText());
        }
        if ((previousPageNode = root.get("previous_page_uri")) != null && !previousPageNode.isNull()) {
            builder.previousPageUri(previousPageNode.asText());
        }
        if ((firstPageNode = root.get("first_page_uri")) != null && !firstPageNode.isNull()) {
            builder.firstPageUri(firstPageNode.asText());
        }
        if ((pageSizeNode = root.get("page_size")) != null && !pageSizeNode.isNull()) {
            builder.pageSize(pageSizeNode.asInt());
        } else {
            builder.pageSize(results.size());
        }
        return builder.records(results).build();
    }

    private static <T> Page<T> buildNextGenPage(JsonNode root, List<T> results) {
        JsonNode pageSizeNode;
        JsonNode firstPageNode;
        JsonNode previousPageNode;
        JsonNode meta = root.get("meta");
        Builder<T> builder = new Builder().uri(URI.create(meta.get("url").asText()).getPath());
        JsonNode nextPageNode = meta.get("next_page_url");
        if (!nextPageNode.isNull()) {
            builder.nextPageUri(URI.create(nextPageNode.asText()).getPath());
        }
        if (!(previousPageNode = meta.get("previous_page_url")).isNull()) {
            builder.previousPageUri(URI.create(previousPageNode.asText()).getPath());
        }
        if (!(firstPageNode = meta.get("first_page_url")).isNull()) {
            builder.firstPageUri(URI.create(firstPageNode.asText()).getPath());
        }
        if (!(pageSizeNode = meta.get("page_size")).isNull()) {
            builder.pageSize(pageSizeNode.asInt());
        } else {
            builder.pageSize(results.size());
        }
        return builder.records(results).build();
    }

    private static class Builder<T> {
        private List<T> records;
        private String firstPageUri;
        private String nextPageUri;
        private String previousPageUri;
        private String uri;
        private int pageSize;

        private Builder() {
        }

        public Builder<T> records(List<T> records) {
            this.records = records;
            return this;
        }

        public Builder<T> firstPageUri(String firstPageUri) {
            this.firstPageUri = firstPageUri;
            return this;
        }

        public Builder<T> nextPageUri(String nextPageUri) {
            this.nextPageUri = nextPageUri;
            return this;
        }

        public Builder<T> previousPageUri(String previousPageUri) {
            this.previousPageUri = previousPageUri;
            return this;
        }

        public Builder<T> uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder<T> pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Page<T> build() {
            return new Page(this);
        }
    }
}

