/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.TaskQueue;

public class TaskQueueReader
extends Reader<TaskQueue> {
    private final String workspaceSid;
    private String friendlyName;
    private String evaluateWorkerAttributes;

    public TaskQueueReader(String workspaceSid) {
        this.workspaceSid = workspaceSid;
    }

    public TaskQueueReader byFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TaskQueueReader byEvaluateWorkerAttributes(String evaluateWorkerAttributes) {
        this.evaluateWorkerAttributes = evaluateWorkerAttributes;
        return this;
    }

    @Override
    public ResourceSet<TaskQueue> execute(TwilioRestClient client) {
        return new ResourceSet<TaskQueue>(this, client, this.firstPage());
    }

    @Override
    public Page<TaskQueue> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/TaskQueues", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TaskQueue> nextPage(Page<TaskQueue> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<TaskQueue> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueue read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("task_queues", response.getContent(), TaskQueue.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.evaluateWorkerAttributes != null) {
            request.addQueryParam("EvaluateWorkerAttributes", this.evaluateWorkerAttributes);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

