/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.taskrouter.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.Workspace;

public class WorkspaceReader
extends Reader<Workspace> {
    private String friendlyName;

    public WorkspaceReader byFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public ResourceSet<Workspace> execute(TwilioRestClient client) {
        return new ResourceSet<Workspace>(this, client, this.firstPage());
    }

    @Override
    public Page<Workspace> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Workspace> nextPage(Page<Workspace> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Workspace> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Workspace read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("workspaces", response.getContent(), Workspace.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

