/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.preview.wireless;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.preview.wireless.Device;

public class DeviceReader
extends Reader<Device> {
    private String status;
    private String simIdentifier;
    private String ratePlan;

    public DeviceReader byStatus(String status) {
        this.status = status;
        return this;
    }

    public DeviceReader bySimIdentifier(String simIdentifier) {
        this.simIdentifier = simIdentifier;
        return this;
    }

    public DeviceReader byRatePlan(String ratePlan) {
        this.ratePlan = ratePlan;
        return this;
    }

    @Override
    public ResourceSet<Device> execute(TwilioRestClient client) {
        return new ResourceSet<Device>(this, client, this.firstPage());
    }

    @Override
    public Page<Device> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.PREVIEW, "/wireless/Devices", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Device> nextPage(Page<Device> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Device> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Device read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("devices", response.getContent(), Device.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.status != null) {
            request.addQueryParam("Status", this.status);
        }
        if (this.simIdentifier != null) {
            request.addQueryParam("SimIdentifier", this.simIdentifier);
        }
        if (this.ratePlan != null) {
            request.addQueryParam("RatePlan", this.ratePlan);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

