/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account.usage;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.usage.Record;

public class RecordReader
extends Reader<Record> {
    private final String accountSid;
    private Record.Category category;
    private String startDate;
    private String endDate;

    public RecordReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public RecordReader byCategory(Record.Category category) {
        this.category = category;
        return this;
    }

    public RecordReader byStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public RecordReader byEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Override
    public ResourceSet<Record> execute(TwilioRestClient client) {
        return new ResourceSet<Record>(this, client, this.firstPage());
    }

    @Override
    public Page<Record> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Usage/Records.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Record> nextPage(Page<Record> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Record> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Record read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("usage_records", response.getContent(), Record.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.category != null) {
            request.addQueryParam("Category", this.category.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate);
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

