/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account.availablephonenumbercountry;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.availablephonenumbercountry.Mobile;

public class MobileReader
extends Reader<Mobile> {
    private final String accountSid;
    private final String countryCode;
    private Integer areaCode;
    private String contains;
    private Boolean smsEnabled;
    private Boolean mmsEnabled;
    private Boolean voiceEnabled;
    private Boolean excludeAllAddressRequired;
    private Boolean excludeLocalAddressRequired;
    private Boolean excludeForeignAddressRequired;
    private Boolean beta;

    public MobileReader(String accountSid, String countryCode) {
        this.accountSid = accountSid;
        this.countryCode = countryCode;
    }

    public MobileReader byAreaCode(Integer areaCode) {
        this.areaCode = areaCode;
        return this;
    }

    public MobileReader byContains(String contains) {
        this.contains = contains;
        return this;
    }

    public MobileReader bySmsEnabled(Boolean smsEnabled) {
        this.smsEnabled = smsEnabled;
        return this;
    }

    public MobileReader byMmsEnabled(Boolean mmsEnabled) {
        this.mmsEnabled = mmsEnabled;
        return this;
    }

    public MobileReader byVoiceEnabled(Boolean voiceEnabled) {
        this.voiceEnabled = voiceEnabled;
        return this;
    }

    public MobileReader byExcludeAllAddressRequired(Boolean excludeAllAddressRequired) {
        this.excludeAllAddressRequired = excludeAllAddressRequired;
        return this;
    }

    public MobileReader byExcludeLocalAddressRequired(Boolean excludeLocalAddressRequired) {
        this.excludeLocalAddressRequired = excludeLocalAddressRequired;
        return this;
    }

    public MobileReader byExcludeForeignAddressRequired(Boolean excludeForeignAddressRequired) {
        this.excludeForeignAddressRequired = excludeForeignAddressRequired;
        return this;
    }

    public MobileReader byBeta(Boolean beta) {
        this.beta = beta;
        return this;
    }

    @Override
    public ResourceSet<Mobile> execute(TwilioRestClient client) {
        return new ResourceSet<Mobile>(this, client, this.firstPage());
    }

    @Override
    public Page<Mobile> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/AvailablePhoneNumbers/" + this.countryCode + "/Mobile.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Mobile> nextPage(Page<Mobile> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Mobile> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Mobile read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("available_phone_numbers", response.getContent(), Mobile.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.areaCode != null) {
            request.addQueryParam("AreaCode", this.areaCode.toString());
        }
        if (this.contains != null) {
            request.addQueryParam("Contains", this.contains);
        }
        if (this.smsEnabled != null) {
            request.addQueryParam("SmsEnabled", this.smsEnabled.toString());
        }
        if (this.mmsEnabled != null) {
            request.addQueryParam("MmsEnabled", this.mmsEnabled.toString());
        }
        if (this.voiceEnabled != null) {
            request.addQueryParam("VoiceEnabled", this.voiceEnabled.toString());
        }
        if (this.excludeAllAddressRequired != null) {
            request.addQueryParam("ExcludeAllAddressRequired", this.excludeAllAddressRequired.toString());
        }
        if (this.excludeLocalAddressRequired != null) {
            request.addQueryParam("ExcludeLocalAddressRequired", this.excludeLocalAddressRequired.toString());
        }
        if (this.excludeForeignAddressRequired != null) {
            request.addQueryParam("ExcludeForeignAddressRequired", this.excludeForeignAddressRequired.toString());
        }
        if (this.beta != null) {
            request.addQueryParam("Beta", this.beta.toString());
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

