/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.Recording;

public class RecordingReader
extends Reader<Recording> {
    private final String accountSid;
    private String dateCreated;

    public RecordingReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public RecordingReader byDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @Override
    public ResourceSet<Recording> execute(TwilioRestClient client) {
        return new ResourceSet<Recording>(this, client, this.firstPage());
    }

    @Override
    public Page<Recording> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Recordings.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Recording> nextPage(Page<Recording> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Recording> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Recording read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("recordings", response.getContent(), Recording.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.dateCreated != null) {
            request.addQueryParam("DateCreated", this.dateCreated);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

