/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.Message;
import com.twilio.sdk.type.PhoneNumber;

public class MessageReader
extends Reader<Message> {
    private final String accountSid;
    private PhoneNumber to;
    private PhoneNumber from;
    private String dateSent;

    public MessageReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public MessageReader byTo(PhoneNumber to) {
        this.to = to;
        return this;
    }

    public MessageReader byFrom(PhoneNumber from) {
        this.from = from;
        return this;
    }

    public MessageReader byDateSent(String dateSent) {
        this.dateSent = dateSent;
        return this;
    }

    @Override
    public ResourceSet<Message> execute(TwilioRestClient client) {
        return new ResourceSet<Message>(this, client, this.firstPage());
    }

    @Override
    public Page<Message> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Messages.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Message> nextPage(Page<Message> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Message> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("messages", response.getContent(), Message.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.to != null) {
            request.addQueryParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addQueryParam("From", this.from.toString());
        }
        if (this.dateSent != null) {
            request.addQueryParam("DateSent", this.dateSent);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

