/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.api.v2010;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.Account;

public class AccountFetcher
extends Fetcher<Account> {
    private final String sid;

    public AccountFetcher(String sid) {
        this.sid = sid;
    }

    @Override
    public Account execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.sid + ".json", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Account fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Account.fromJson(response.getStream(), client.getObjectMapper());
    }
}

