/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.deleter.api.v2010.account.call;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.deleter.Deleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.call.Recording;

public class RecordingDeleter
extends Deleter<Recording> {
    private final String accountSid;
    private final String callSid;
    private final String sid;

    public RecordingDeleter(String accountSid, String callSid, String sid) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.sid = sid;
    }

    @Override
    public boolean execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.DELETE, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Calls/" + this.callSid + "/Recordings/" + this.sid + ".json", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Recording delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return response.getStatusCode() == 204;
    }
}

