/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.trunking.v1.trunk;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.trunking.v1.trunk.OriginationUrl;
import java.net.URI;

public class OriginationUrlCreator
extends Creator<OriginationUrl> {
    private final String trunkSid;
    private final Integer weight;
    private final Integer priority;
    private final Boolean enabled;
    private final String friendlyName;
    private final URI sipUrl;

    public OriginationUrlCreator(String trunkSid, Integer weight, Integer priority, Boolean enabled, String friendlyName, URI sipUrl) {
        this.trunkSid = trunkSid;
        this.weight = weight;
        this.priority = priority;
        this.enabled = enabled;
        this.friendlyName = friendlyName;
        this.sipUrl = sipUrl;
    }

    @Override
    public OriginationUrl execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TRUNKING, "/v1/Trunks/" + this.trunkSid + "/OriginationUrls", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("OriginationUrl creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return OriginationUrl.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.weight != null) {
            request.addPostParam("Weight", this.weight.toString());
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
        if (this.enabled != null) {
            request.addPostParam("Enabled", this.enabled.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.sipUrl != null) {
            request.addPostParam("SipUrl", this.sipUrl.toString());
        }
    }
}

