/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.TaskQueue;

public class TaskQueueCreator
extends Creator<TaskQueue> {
    private final String workspaceSid;
    private final String friendlyName;
    private final String reservationActivitySid;
    private final String assignmentActivitySid;
    private String targetWorkers;
    private Integer maxReservedWorkers;

    public TaskQueueCreator(String workspaceSid, String friendlyName, String reservationActivitySid, String assignmentActivitySid) {
        this.workspaceSid = workspaceSid;
        this.friendlyName = friendlyName;
        this.reservationActivitySid = reservationActivitySid;
        this.assignmentActivitySid = assignmentActivitySid;
    }

    public TaskQueueCreator setTargetWorkers(String targetWorkers) {
        this.targetWorkers = targetWorkers;
        return this;
    }

    public TaskQueueCreator setMaxReservedWorkers(Integer maxReservedWorkers) {
        this.maxReservedWorkers = maxReservedWorkers;
        return this;
    }

    @Override
    public TaskQueue execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/TaskQueues", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueue creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return TaskQueue.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.reservationActivitySid != null) {
            request.addPostParam("ReservationActivitySid", this.reservationActivitySid);
        }
        if (this.assignmentActivitySid != null) {
            request.addPostParam("AssignmentActivitySid", this.assignmentActivitySid);
        }
        if (this.targetWorkers != null) {
            request.addPostParam("TargetWorkers", this.targetWorkers);
        }
        if (this.maxReservedWorkers != null) {
            request.addPostParam("MaxReservedWorkers", this.maxReservedWorkers.toString());
        }
    }
}

