/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.ipmessaging.v1.service;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.ipmessaging.v1.service.Channel;
import java.util.Map;

public class ChannelCreator
extends Creator<Channel> {
    private final String serviceSid;
    private final String friendlyName;
    private final String uniqueName;
    private Map<String, Object> attributes;
    private Channel.ChannelType type;

    public ChannelCreator(String serviceSid, String friendlyName, String uniqueName) {
        this.serviceSid = serviceSid;
        this.friendlyName = friendlyName;
        this.uniqueName = uniqueName;
    }

    public ChannelCreator setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ChannelCreator setType(Channel.ChannelType type) {
        this.type = type;
        return this;
    }

    @Override
    public Channel execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.IPMESSAGING, "/v1/Services/" + this.serviceSid + "/Channels", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Channel creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Channel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes.toString());
        }
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
    }
}

