/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.conversations.v1.conversation;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.conversations.v1.conversation.Participant;
import com.twilio.sdk.type.PhoneNumber;

public class ParticipantCreator
extends Creator<Participant> {
    private final String conversationSid;
    private final PhoneNumber to;
    private final PhoneNumber from;

    public ParticipantCreator(String conversationSid, PhoneNumber to, PhoneNumber from) {
        this.conversationSid = conversationSid;
        this.to = to;
        this.from = from;
    }

    @Override
    public Participant execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.CONVERSATIONS, "/v1/Conversations/" + this.conversationSid + "/Participants", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant creation failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 201) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.to != null) {
            request.addPostParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addPostParam("From", this.from.toString());
        }
    }
}

