/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.api.v2010.account.sip;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.sip.Domain;
import java.net.URI;

public class DomainCreator
extends Creator<Domain> {
    private final String accountSid;
    private final String domainName;
    private String friendlyName;
    private URI voiceUrl;
    private HttpMethod voiceMethod;
    private URI voiceFallbackUrl;
    private HttpMethod voiceFallbackMethod;
    private URI voiceStatusCallbackUrl;
    private HttpMethod voiceStatusCallbackMethod;

    public DomainCreator(String accountSid, String domainName) {
        this.accountSid = accountSid;
        this.domainName = domainName;
    }

    public DomainCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public DomainCreator setVoiceUrl(URI voiceUrl) {
        this.voiceUrl = voiceUrl;
        return this;
    }

    public DomainCreator setVoiceUrl(String voiceUrl) {
        return this.setVoiceUrl(Promoter.uriFromString(voiceUrl));
    }

    public DomainCreator setVoiceMethod(HttpMethod voiceMethod) {
        this.voiceMethod = voiceMethod;
        return this;
    }

    public DomainCreator setVoiceFallbackUrl(URI voiceFallbackUrl) {
        this.voiceFallbackUrl = voiceFallbackUrl;
        return this;
    }

    public DomainCreator setVoiceFallbackUrl(String voiceFallbackUrl) {
        return this.setVoiceFallbackUrl(Promoter.uriFromString(voiceFallbackUrl));
    }

    public DomainCreator setVoiceFallbackMethod(HttpMethod voiceFallbackMethod) {
        this.voiceFallbackMethod = voiceFallbackMethod;
        return this;
    }

    public DomainCreator setVoiceStatusCallbackUrl(URI voiceStatusCallbackUrl) {
        this.voiceStatusCallbackUrl = voiceStatusCallbackUrl;
        return this;
    }

    public DomainCreator setVoiceStatusCallbackUrl(String voiceStatusCallbackUrl) {
        return this.setVoiceStatusCallbackUrl(Promoter.uriFromString(voiceStatusCallbackUrl));
    }

    public DomainCreator setVoiceStatusCallbackMethod(HttpMethod voiceStatusCallbackMethod) {
        this.voiceStatusCallbackMethod = voiceStatusCallbackMethod;
        return this;
    }

    @Override
    public Domain execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/SIP/Domains.json", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Domain creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Domain.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.domainName != null) {
            request.addPostParam("DomainName", this.domainName);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.voiceUrl != null) {
            request.addPostParam("VoiceUrl", this.voiceUrl.toString());
        }
        if (this.voiceMethod != null) {
            request.addPostParam("VoiceMethod", this.voiceMethod.toString());
        }
        if (this.voiceFallbackUrl != null) {
            request.addPostParam("VoiceFallbackUrl", this.voiceFallbackUrl.toString());
        }
        if (this.voiceFallbackMethod != null) {
            request.addPostParam("VoiceFallbackMethod", this.voiceFallbackMethod.toString());
        }
        if (this.voiceStatusCallbackUrl != null) {
            request.addPostParam("VoiceStatusCallbackUrl", this.voiceStatusCallbackUrl.toString());
        }
        if (this.voiceStatusCallbackMethod != null) {
            request.addPostParam("VoiceStatusCallbackMethod", this.voiceStatusCallbackMethod.toString());
        }
    }
}

