/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.example;

import com.twilio.sdk.Twilio;
import com.twilio.sdk.creator.api.v2010.account.CallCreator;
import com.twilio.sdk.creator.api.v2010.account.IncomingPhoneNumberCreator;
import com.twilio.sdk.creator.api.v2010.account.MessageCreator;
import com.twilio.sdk.creator.trunking.v1.TrunkCreator;
import com.twilio.sdk.reader.api.v2010.account.CallReader;
import com.twilio.sdk.reader.api.v2010.account.MessageReader;
import com.twilio.sdk.reader.api.v2010.account.availablephonenumbercountry.LocalReader;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.api.v2010.account.Call;
import com.twilio.sdk.resource.api.v2010.account.IncomingPhoneNumber;
import com.twilio.sdk.resource.api.v2010.account.Message;
import com.twilio.sdk.resource.api.v2010.account.availablephonenumbercountry.Local;
import com.twilio.sdk.resource.notifications.v1.Service;
import com.twilio.sdk.resource.trunking.v1.Trunk;
import com.twilio.sdk.type.PhoneNumber;
import com.twilio.twiml.Play;
import com.twilio.twiml.Say;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.VoiceResponse;
import java.net.URI;
import java.util.Iterator;

public class Example {
    public static final String ACCOUNT_SID = System.getenv("TWILIO_ACCOUNT_SID");
    public static final String AUTH_TOKEN = System.getenv("TWILIO_AUTH_TOKEN");
    public static final PhoneNumber PHONE_NUMBER = new PhoneNumber("+18885551234");

    public static void main(String[] args) throws TwiMLException {
        Twilio.init(ACCOUNT_SID, AUTH_TOKEN);
        IncomingPhoneNumber number = Example.buyNumber();
        System.out.println(number.getPhoneNumber());
        Message message = (Message)new MessageCreator(ACCOUNT_SID, PHONE_NUMBER, number.getPhoneNumber(), "Hello world!").execute();
        System.out.println(message.getSid());
        System.out.println(message.getBody());
        Call call = (Call)new CallCreator(ACCOUNT_SID, PHONE_NUMBER, number.getPhoneNumber(), URI.create("https://twilio.com")).execute();
        System.out.println(call.getSid());
        ResourceSet messages = new MessageReader(ACCOUNT_SID).execute();
        for (Object m : messages) {
            System.out.println(((Message)m).getSid());
            System.out.println(((Message)m).getBody());
        }
        ResourceSet calls = new CallReader(ACCOUNT_SID).pageSize(2).execute();
        for (Call c : calls) {
            System.out.println(c.getSid());
        }
        Trunk trunk = (Trunk)new TrunkCreator().setFriendlyName("shiny trunk").setSecure(false).execute();
        System.out.println(trunk);
        Service service = (Service)Service.create().execute();
        boolean result = Service.delete(service.getSid()).execute();
        System.out.println(result);
        VoiceResponse twiml = new VoiceResponse.Builder().say(new Say.Builder("Hello World!").build()).play(new Play.Builder("https://api.twilio.com/cowbell.mp3").loop(5).build()).build();
        System.out.println(twiml.toXml());
    }

    private static IncomingPhoneNumber buyNumber() {
        ResourceSet numbers = new LocalReader(ACCOUNT_SID, "US").execute();
        Iterator iter = numbers.iterator();
        if (iter.hasNext()) {
            Local local = (Local)iter.next();
            return (IncomingPhoneNumber)new IncomingPhoneNumberCreator(ACCOUNT_SID, local.getPhoneNumber()).execute();
        }
        return null;
    }
}

