/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.conversations;

import com.twilio.sdk.TwilioConversationsClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.NextGenListResource;
import com.twilio.sdk.resource.factory.Factory;
import com.twilio.sdk.resource.instance.conversations.Participant;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class ParticipantList
extends NextGenListResource<Participant, TwilioConversationsClient>
implements Factory<Participant> {
    private String conversationSid;

    public ParticipantList(TwilioConversationsClient client, String conversationSid) {
        super(client);
        this.conversationSid = conversationSid;
    }

    public ParticipantList(TwilioConversationsClient client, Map<String, String> filters, String conversationSid) {
        super(client, filters);
        this.conversationSid = conversationSid;
    }

    @Override
    public Participant create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioConversationsClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioConversationsClient)this.getClient(), response.toMap());
    }

    @Override
    public Participant create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioConversationsClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioConversationsClient)this.getClient(), response.toMap());
    }

    @Override
    protected Participant makeNew(TwilioConversationsClient client, Map<String, Object> params) {
        return new Participant(client, params);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Conversations/" + this.conversationSid + "/Participants";
    }
}

