/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.util.Date;
import java.util.Map;

public class Transcription
extends InstanceResource<TwilioRestClient> {
    public Transcription(TwilioRestClient client) {
        super(client);
    }

    public Transcription(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Transcription can not be null");
        }
        this.setProperty("sid", sid);
    }

    public Transcription(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Transcriptions/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getStatus() {
        return this.getProperty("status");
    }

    public String getRecordingSid() {
        return this.getProperty("recording_sid");
    }

    public int getDuration() {
        return Integer.parseInt(this.getProperty("duration"));
    }

    public String getPrice() {
        return this.getProperty("price");
    }

    public String getTranscriptionText() {
        return this.getProperty("transcription_text");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

