/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.InstanceResource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Token
extends InstanceResource {
    public Token(TwilioRestClient client) {
        super(client);
    }

    @Override
    protected String getResourceLocation() {
        return null;
    }

    public Token(TwilioRestClient client, String username) {
        super(client);
        if (username == null) {
            throw new IllegalStateException("The username for a Token can not be null");
        }
        this.setProperty("username", username);
    }

    public Token(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public String getSid() {
        return this.getProperty("username");
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getUsername() {
        return this.getProperty("username");
    }

    public String getPassword() {
        return this.getProperty("password");
    }

    public int getTtl() {
        return Integer.parseInt(this.getProperty("ttl"));
    }

    public List<IceServer> getIceServers() {
        ArrayList<IceServer> iceServers = new ArrayList<IceServer>();
        for (Map server : (List)this.getObject("ice_servers")) {
            IceServer token = new IceServer(server);
            iceServers.add(token);
        }
        return iceServers;
    }

    class IceServer {
        public final String url;
        public final String username;
        public final String credential;

        public IceServer(Map<String, String> params) {
            String serverUrl = null;
            String serverUsername = null;
            String serverCredential = null;
            if (params.containsKey("url")) {
                serverUrl = params.get("url");
            }
            if (params.containsKey("username")) {
                serverUsername = params.get("username");
            }
            if (params.containsKey("credential")) {
                serverCredential = params.get("credential");
            }
            this.url = serverUrl;
            this.username = serverUsername;
            this.credential = serverCredential;
        }

        public boolean hasUsername() {
            return this.url != null;
        }

        public boolean hasCredential() {
            return this.url != null;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getCredential() {
            return this.credential;
        }
    }
}

