/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.TwilioClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.resource.instance.trunking.CredentialList;
import com.twilio.sdk.resource.instance.trunking.IpAccessControlList;
import com.twilio.sdk.resource.instance.trunking.OriginationUrl;
import com.twilio.sdk.resource.instance.trunking.PhoneNumber;
import com.twilio.sdk.resource.instance.trunking.Trunk;
import com.twilio.sdk.resource.list.trunking.TrunkList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class TwilioTrunkingClient
extends TwilioClient {
    public static final String DEFAULT_VERSION = "v1";

    public TwilioTrunkingClient(String username, String password) {
        this(username, password, "https://trunking.twilio.com");
    }

    public TwilioTrunkingClient(String username, String password, String endpoint) {
        super(username, password, endpoint);
    }

    public TrunkList getTrunks(Map<String, String> filters) {
        return new TrunkList(this, filters);
    }

    public TrunkList getTrunks() {
        return new TrunkList(this);
    }

    public Trunk getTrunk(String trunkSid) {
        return new Trunk(this, trunkSid);
    }

    public Trunk createTrunk(Map<String, String> params) throws TwilioRestException {
        return this.getTrunks().create((Map)params);
    }

    public Trunk createTrunk(List<NameValuePair> params) throws TwilioRestException {
        return this.getTrunks().create((List)params);
    }

    public PhoneNumber associatePhoneNumber(String trunkSid, Map<String, String> params) throws TwilioRestException {
        return this.getTrunk(trunkSid).getPhoneNumbers().create((Map)params);
    }

    public PhoneNumber associatePhoneNumber(String trunkSid, List<NameValuePair> params) throws TwilioRestException {
        return this.getTrunk(trunkSid).getPhoneNumbers().create((List)params);
    }

    public OriginationUrl createOriginationUrl(String trunkSid, Map<String, String> params) throws TwilioRestException {
        return this.getTrunk(trunkSid).getOriginationUrls().create((Map)params);
    }

    public OriginationUrl createOriginationUrl(String trunkSid, List<NameValuePair> params) throws TwilioRestException {
        return this.getTrunk(trunkSid).getOriginationUrls().create((List)params);
    }

    public CredentialList associateCredentialList(String trunkSid, Map<String, String> params) throws TwilioRestException {
        return this.getTrunk(trunkSid).getCredentialLists().create((Map)params);
    }

    public CredentialList associateCredentialList(String trunkSid, List<NameValuePair> params) throws TwilioRestException {
        return this.getTrunk(trunkSid).getCredentialLists().create((List)params);
    }

    public IpAccessControlList associateIpAccessControlList(String trunkSid, Map<String, String> params) throws TwilioRestException {
        return this.getTrunk(trunkSid).getIpAccessControlLists().create((Map)params);
    }

    public IpAccessControlList associateIpAccessControlListt(String trunkSid, List<NameValuePair> params) throws TwilioRestException {
        return this.getTrunk(trunkSid).getIpAccessControlLists().create((List)params);
    }
}

