/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Reservation
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String TASK_SID_PROPERTY = "task_sid";
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";
    private static final Map<String, String> ACCEPT_RESERVATION_PARAMS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("ReservationStatus", "accepted");
        }
    });
    private static final Map<String, String> REJECT_RESERVATION_PARAMS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("ReservationStatus", "rejected");
        }
    });

    public Reservation(TwilioTaskRouterClient client) {
        super(client);
    }

    public Reservation(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Reservation(TwilioTaskRouterClient client, String workspaceSid, String taskSid, String reservationSid) {
        super(client);
        if (StringUtils.isBlank((CharSequence)workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for a Reservation cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)taskSid)) {
            throw new IllegalArgumentException("The taskSid for a Reservation cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)reservationSid)) {
            throw new IllegalArgumentException("The reservationSid for a Reservation cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty(TASK_SID_PROPERTY, taskSid);
        this.setProperty("sid", reservationSid);
    }

    public void accept() throws TwilioRestException {
        this.update(ACCEPT_RESERVATION_PARAMS);
    }

    public void reject() throws TwilioRestException {
        this.update(REJECT_RESERVATION_PARAMS);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public Date getDateCreated() {
        return this.parseDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseDate(this.getProperty("date_updated"));
    }

    public String getReservationStatus() {
        return this.getProperty("reservation_status");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getTaskSid() {
        return this.getProperty(TASK_SID_PROPERTY);
    }

    public String getWorkerName() {
        return this.getProperty("worker_name");
    }

    public String getWorkerSid() {
        return this.getProperty("worker_sid");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Tasks/" + this.getTaskSid() + "/Reservations/" + this.getSid();
    }
}

