/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;

public class Event
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public Event(TwilioTaskRouterClient client) {
        super(client);
    }

    public Event(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Event(TwilioTaskRouterClient client, String workspaceSid, String eventSid) {
        super(client);
        if (workspaceSid == null || "".equals(workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for an Worker cannot be null");
        }
        if (eventSid == null || "".equals(eventSid)) {
            throw new IllegalArgumentException("The eventSid for an Event cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty("sid", eventSid);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getActorSid() {
        return this.getProperty("actor_sid");
    }

    public String getActorType() {
        return this.getProperty("actor_type");
    }

    public String getActorUrl() {
        return this.getProperty("actor_url");
    }

    public String getDescription() {
        return this.getProperty("description");
    }

    public Map<String, String> getEventData() {
        return (Map)this.getObject("event_data");
    }

    public Calendar getEventDate() {
        return this.parseCalendar(this.getProperty("event_date"));
    }

    public String getEventType() {
        return this.getProperty("event_type");
    }

    public String getResourceSid() {
        return this.getProperty("resource_sid");
    }

    public String getResourceType() {
        return this.getProperty("resource_type");
    }

    public String getResourceUrl() {
        return this.getProperty("resource_url");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getSource() {
        return this.getProperty("source");
    }

    public String getSourceIpAddress() {
        return this.getProperty("source_ip_address");
    }

    public String getWorkspaceSid() {
        String sid = this.getProperty(WORKSPACE_SID_PROPERTY);
        if (sid == null || "" == sid) {
            Map<String, String> eventData = this.getEventData();
            if (eventData == null) {
                return null;
            }
            return eventData.get(WORKSPACE_SID_PROPERTY);
        }
        return sid;
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Events/" + this.getSid();
    }
}

